//
//  main.m
//  MIDI Parsing 1
//
//  Created by Eric Knapp on 3/30/14.
//  Copyright (c) 2014 Eric Knapp. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <AudioToolbox/AudioToolbox.h>

void parseTempoTrack(MusicSequence sequence)
{
    // Get the Tempo Track
    MusicTrack tempoTrack;
    MusicSequenceGetTempoTrack(sequence, &tempoTrack);
    
    // Create an iterator that will loop through the events in the track
    MusicEventIterator iterator;
    NewMusicEventIterator(tempoTrack, &iterator);
    
    Boolean hasNext = YES;
    MusicTimeStamp timestamp = 0;
    MusicEventType eventType = 0;
    const void *eventData = NULL;
    UInt32 eventDataSize = 0;
    
    // Run the loop
    MusicEventIteratorHasCurrentEvent(iterator, &hasNext);
    while (hasNext) {
        MusicEventIteratorGetEventInfo(iterator,
                                       &timestamp,
                                       &eventType,
                                       &eventData,
                                       &eventDataSize);
        
        // Process each event here
        printf("Event found! type: %d\n", eventType);
        
        MusicEventIteratorNextEvent(iterator);
        MusicEventIteratorHasCurrentEvent(iterator, &hasNext);
    }
}

void parseTrackForMIDIEvents(MusicEventIterator iterator)
{
    MusicTimeStamp timestamp = 0;
    MusicEventType eventType = 0;
    const void *eventData = NULL;
    UInt32 eventDataSize = 0;
    Boolean hasNext = YES;

    MusicEventIteratorHasCurrentEvent(iterator, &hasNext);
    while (hasNext) {
        MusicEventIteratorGetEventInfo(iterator, &timestamp, &eventType, &eventData, &eventDataSize);
        if (eventType == kMusicEventType_MIDINoteMessage) {
            MIDINoteMessage *noteMessage = (MIDINoteMessage*)eventData;
            printf("Note - timestamp: %6.3f, channel: %d, note: %d, velocity: %d, release velocity: %d, duration: %.3f\n",
                   timestamp,
                   noteMessage->channel,
                   noteMessage->note,
                   noteMessage->velocity,
                   noteMessage->releaseVelocity,
                   noteMessage->duration
                   );
        }
        MusicEventIteratorNextEvent(iterator);
        MusicEventIteratorHasCurrentEvent(iterator, &hasNext);
    }
}

void parseMIDIEventTracks(MusicSequence sequence)
{
    UInt32 trackCount;
    MusicSequenceGetTrackCount(sequence, &trackCount);

    MusicTrack track = NULL;

    for (UInt32 index = 0; index < trackCount; index++) {
        MusicSequenceGetIndTrack(sequence, index, &track);
        MusicEventIterator iterator = NULL;
        NewMusicEventIterator(track, &iterator);
        parseTrackForMIDIEvents(iterator);
    }
}

int main(int argc, const char * argv[])
{
    // Load the MIDI File
    MusicSequence sequence;
    NewMusicSequence(&sequence);

    NSURL *midiFileURL
            = [NSURL fileURLWithPath:@"/Users/<user>/Desktop/bach-invention-01.mid"];

    MusicSequenceFileLoad(sequence, (__bridge CFURLRef)midiFileURL, 0, 0);

    parseTempoTrack(sequence);

    parseMIDIEventTracks(sequence);

    return 0;
}
